import React from 'react'
import styles from './style.module.scss'
import Image from 'next/image'
import gonsa from '../../assets/gonsa.png'
import marques from '../../assets/marques.png'
import vilela from '../../assets/vilela.png'
import office from '../../assets/office.png'

const AboutUs = () => {
  const founders = [{name: 'Vitor Marques', src: marques, description: 'A empresa de vale transporte foi a solução que eu precisava para oferecer um benefício justo e eficiente para meus colaboradores. O processo de adesão foi fácil e rápido, e os benefícios foram sentidos tanto pelos funcionários quanto pela gestão da empresa.'},{name: 'Henrique Gonsales', src: gonsa, description: 'Desde que comecei a utilizar os vales transporte da empresa, minha vida melhorou muito. Antes, gastava muito tempo e dinheiro no transporte público, mas agora consigo me deslocar de forma mais rápida e econômica. Sem contar que a empresa oferece um atendimento de excelência.'},{name: 'Ana Vilela', src: vilela, description: 'Estou muito satisfeito com os serviços da empresa de vale transporte. Eles sempre oferecem soluções personalizadas e adequadas às necessidades da minha empresa. Além disso, o suporte técnico é muito eficiente e atencioso, o que me passa uma grande segurança.'},]
  return (
    <div className={styles.section_wrapper}>
      <div className={styles.about_item_container}>
        <div className={styles.about_item_content}>
          <h2>Nossa história</h2>
          <div className={styles.our_history}>
            <p>A Moov Itaquá nasceu do desejo de oferecer soluções mais vantajosas de benefícios de vale transporte para as empresas e também facilitar o acesso de pessoas físicas a opções mais eficientes, funcionais e relevantes para a utilização de transporte coletivo, como ônibus, interurbano e metrô em Itaquá e arredores.</p>
            <p>Temos soluções de benefícios Vale Transporte, para que empresas em todo o Brasil possam contratar o serviço para oferecer a seus colaboradores este benefício e gerenciar facilmente pelos nosso serviços digitais, auxiliando na economia de tempo e trazendo maior agilidade para o pessoal do RH.</p>
            <p>Com transparência e confiança, queremos nos inserir no mercado, expandir mais a área de abrangência e com o tempo construir um legado dentro do segmento.</p>
          </div>
        </div>

        <div className={styles.big_img}>
          <Image src={office} alt='Moov Itaguá logo' style={{objectFit: 'contain', width: '100%',  height: 'auto', overflow: 'hidden'}} />
        </div>
      </div>
      <div className={styles.founders}>
        {founders.map(item => (
          <div key={item.name} className={styles.founder_card}>
            <div className="">
              <Image src={item.src} alt={item.name} width={168} height={168} style={{objectFit: 'contain', borderRadius: '50%', overflow: 'hidden'}} />
            </div>
            <div className={styles.name}>{item.name}</div>
            <div className={styles.description}>{item.description}</div>
          </div>
        ))}
      </div>
    </div>
  )
}

export default AboutUs
