import { useEffect } from 'react';
import styles from './styles.module.scss';

interface CadastroModalProps {
  isOpen: boolean;
  handleCloseModal: () => void;
}

const CadastroModal = ({ isOpen, handleCloseModal }: CadastroModalProps) => {
  useEffect(() => {
    const handleOutsideClick = (event: any) => {
      if (event.target.id === 'cadastro-overlay') {
        handleCloseModal();
      }
    };

    const handleEscapeKey = (event: KeyboardEvent) => {
      if (event.key === 'Escape') {
        handleCloseModal();
      }
    };

    if (isOpen) {
      window.addEventListener('click', handleOutsideClick);
      window.addEventListener('keydown', handleEscapeKey);
      document.body.style.overflow = 'hidden'; // Previne scroll do body
    }

    return () => {
      window.removeEventListener('click', handleOutsideClick);
      window.removeEventListener('keydown', handleEscapeKey);
      document.body.style.overflow = 'unset';
    };
  }, [handleCloseModal, isOpen]);

  if (!isOpen) return null;

  return (
    <div className={styles.modal_overlay} id="cadastro-overlay">
      <div className={styles.modal}>
        <div className={styles.modal_header}>
          <button className={styles.modal_close} onClick={handleCloseModal}>
            &times;
          </button>
        </div>
        <div className={styles.modal_content}>
          <div className={styles.message_container}>
            <h2 className={styles.title}>Informações sobre Cadastro</h2>
            <p className={styles.message}>
              Solicitamos que entre em contato com o setor de Vale-Transporte para dar continuidade ao processo, por meio do e-mail{' '}
              <a href="mailto:empresas@moovitaqua.com.br" className={styles.email_link}>
                empresas@moovitaqua.com.br
              </a>{' '}
              ou pelo WhatsApp{' '}
              <a href="https://wa.me/5511972171926" target="_blank" rel="noopener noreferrer" className={styles.whatsapp_link}>
                (11) 97217-1926
              </a>
              .
            </p>
            <p className={styles.signature}>A Equipe Moov agradece.</p>
          </div>
        </div>
      </div>
    </div>
  );
};

export default CadastroModal;
