import React, { useRef } from 'react';
import Slider from "react-slick";
import "slick-carousel/slick/slick.css";
import "slick-carousel/slick/slick-theme.css";

import Image from 'next/image';
import styles from './style.module.scss';
import styleBanner1 from './styleBanner1.module.scss';
import styleBanner2 from './styleBanner2.module.scss';
import styleBanner3 from './styleBanner3.module.scss';
import styleBanner4 from './styleBanner4.module.scss';
import homeBannerImg1 from '../../assets/imgCarrossel/home-banner-1.png'
import homeBannerImg1Mobile from '../../assets/imgCarrossel/home-banner-1-mobile.png'
import homeBannerImg2Mobile from '../../assets/imgCarrossel/home-banner-2-mobile.png'
import homeBannerImg3Mobile from '../../assets/imgCarrossel/home-banner-3-mobile.png'
import homeBannerImg4Mobile from '../../assets/imgCarrossel/home-banner-4-mobile.png'
import homeBannerImg2 from '../../assets/imgCarrossel/home-banner-2.png'
import homeBannerImg3 from '../../assets/imgCarrossel/home-banner-3.png'
import homeBannerImg4 from '../../assets/imgCarrossel/home-banner-4.png'
import whatsapp from '../../assets/imgCarrossel/whatsappButton.png'

import ChevronLeft from '../../fragments/ChevronLeft'
import ChevronRight from '../../fragments/ChevronRight'

const formularioEscolar:string = "https://moovitaqua.com.br/documentos/formulario-escolhar-moov-2026.pdf"
const whatsappLink:string = "https://wa.me/5511933152362"

const Carousel = () => {
  const sliderRef = useRef<Slider | null>(null);

  const settings = {
    dots: true,
    infinite: true,
    speed: 500,
    slidesToShow: 1,
    slidesToScroll: 1,
    arrows: false,
    adaptiveHeight: true,
  };

  return (
    <section className={styles.sectionSlideShow}>
      <Slider ref={sliderRef} {...settings}>
        <div>
          <div className={`${styleBanner1.slide}`}>
            <img
              src={homeBannerImg1.src}
              alt=""
              className={styleBanner1.slideImage}
            />

            <img
              src={homeBannerImg1Mobile.src}
              alt=""
              className={styleBanner1.slideImageMobile}
            />

            <div className={styleBanner1.textContent}>
              <h3>Recarregue seu cartão Viaja Fácil pelo Whatsapp</h3>
              <button
                className={styles.ctaButton}
                onClick={() => window.open(whatsappLink, "_blank")}
              >
                Recarregar agora!
              </button>
            </div>
          </div>
        </div>

        <div className={styleBanner2.slide} id='escolar'>
          <img
            src={homeBannerImg2.src}
            alt=""
            className={styleBanner2.slideImage}
          />

          <img
            src={homeBannerImg2Mobile.src}
            alt=""
            className={styleBanner2.slideImageMobile}
          />

          <div className={`${styleBanner2.textContent}`}>
            <h2 style={{ color: '#00BAB3' }}>Escolar</h2>
            <ol>
              <li>
                Faça o download do formulário clicando no botão{' '}
                <a href={formularioEscolar} target='_blank' style={{ color: '#00A29E', textDecoration: 'underline', fontWeight: 'bold' }}>
                  &quot;Baixar formulário escolar&quot;
                </a>
                , imprima frente e verso e preencha conforme instruções no verso;
              </li>
              <li>Leve à sua escola para assinar e carimbar na direção.</li>
              <li>
                Encaminhe ao e-mail:{' '}
                <a href="mailto:escolar@moovitaqua.com.br" style={{ color: '#00A29E' }}>
                  escolar@moovitaqua.com.br
                </a>
                .
              </li>
              <li>
                Anexe os documentos solicitados no verso da folha (RG e comprovante de
                endereço recente até três meses, etc).
              </li>
              <li>
                Após o envio, aguarde até 3 dias úteis para aprovação do cadastro.
              </li>
              <li>
                Ao receber o e-mail de aprovação, compareça à loja Moov Itaquá para
                validação do cartão.
              </li>
              <li>
                A validação do cartão escolar tem taxa de R$21,30 (vinte e um reais e
                trinta centavos).
              </li>
            </ol>
          </div>
        </div>

        <div className={styleBanner3.slide}>
          <img
            src={homeBannerImg3.src}
            alt=""
            className={styleBanner3.slideImage}
          />
          <img
            src={homeBannerImg3Mobile.src}
            alt=""
            className={styles.slideImageMobile}
          />

          <div className={styleBanner3.textContent}>
            <h3>Faça sua primeira via do cartão VIAJA FÁCIL</h3>
            <a href="#thirdSession">
              <button className={styles.ctaButton} >
                Solicitar agora
              </button>
            </a>
          </div>
        </div>

        <div className={styleBanner4.slide}>
          <img
            src={homeBannerImg4.src}
            alt=""
            className={styleBanner4.slideImage}
          />
          <img
            src={homeBannerImg4Mobile.src}
            alt=""
            className={styles.slideImageMobile}
          />

          <div className={styleBanner4.textContent}>
            <h3>Biometria Facial: mais segurança para todos.</h3>
            <br />
            <p>Ação que visa a redução de fraudes através de
            captura automática da imagem do passageiro
            dentro do ônibus.</p>
            <br />
            <p>Ao embarcar, a câmera registra uma sequência de imagens no momento que o passageiro aproxima seu cartão no validador, a câmera registra as imagens e as vincula ao cadastro do passageiro.</p>
          </div>
        </div>
      </Slider>

      <div className={styles.arrows}>
        <button
          className={`${styles.arrow} ${styles.arrowLeft}`}
          onClick={() => sliderRef.current?.slickPrev()}
          >
          <ChevronLeft />
        </button>

        <button
          className={`${styles.arrow} ${styles.arrowRight}`}
          onClick={() => sliderRef.current?.slickNext()}
          >
          <ChevronRight />
        </button>
      </div>
    </section>
  );
};

export default Carousel;
