import React, { ChangeEvent, useRef, useState } from "react";
import styles from "./style.module.scss";
import ButtonFragment from "@/fragments/button";
import api from "@/services/api";

const ContactForm = () => {
  const inputs = [
    { name: "name", label: "Nome", type: "text" },
    { name: "email", label: "E-mail", type: "email" },
    { name: "message", label: "Deixe sua mensagem", type: "text" },
  ];
  const fields_ref = useRef({ name: "", email: "", message: "" });
  const [isSubmitted, setIsSubmitted] = useState(false);

  const handleChange = (e: any) => {
    const { name, value } = e.target;
    fields_ref.current = { ...fields_ref.current, [name]: value };
  };

  const handleSubmit = async (e: any) => {
    e.preventDefault();
    try {
      const res = await fetch("/api/email", {
        method: "POST",
        headers: {
          Accept: "application/json",
          "Content-Type": "application/json",
        },
        body: JSON.stringify(fields_ref.current),
      });
      setIsSubmitted(true);
    } catch (error) {
      console.log(error);
    }
  };
  return (
    <div className={styles.contact_wrapper}>
      <div className={styles.contact_box}>
        <div className={styles.contact_container}>
          <h2>Entre em contato conosco</h2>
          <div className={styles.contact_content}>
            <div className={styles.information_container}>
              <div className={styles.contact_info}>
                <div className={styles.info}>
                  <svg
                    width="24"
                    height="18"
                    viewBox="0 0 24 18"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <path
                      d="M0.075 2.3325C0.226227 1.66986 0.597983 1.07822 1.12938 0.654463C1.66078 0.230706 2.32033 -4.57416e-05 3 6.80121e-09H21C21.6797 -4.57416e-05 22.3392 0.230706 22.8706 0.654463C23.402 1.07822 23.7738 1.66986 23.925 2.3325L12 9.621L0.075 2.3325ZM0 4.0455V14.7015L8.7045 9.3645L0 4.0455ZM10.1415 10.245L0.2865 16.2855C0.52999 16.7989 0.91429 17.2326 1.39467 17.5362C1.87505 17.8397 2.43176 18.0005 3 18H21C21.5681 18.0001 22.1246 17.8389 22.6048 17.5351C23.0849 17.2313 23.4688 16.7975 23.712 16.284L13.857 10.2435L12 11.379L10.1415 10.2435V10.245ZM15.2955 9.366L24 14.7015V4.0455L15.2955 9.3645V9.366Z"
                      fill="#622167"
                    />
                  </svg>
                  <p>atendimento@moovitaqua.com.br</p>
                </div>
                <div className={styles.info}>
                  <svg
                    width="24"
                    height="24"
                    viewBox="0 0 24 24"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <path
                      fillRule="evenodd"
                      clipRule="evenodd"
                      d="M2.82747 0.766476C3.08994 0.504409 3.4051 0.301114 3.75207 0.170061C4.09904 0.0390087 4.46991 -0.0168078 4.84008 0.00631052C5.21026 0.0294288 5.5713 0.130954 5.89927 0.304158C6.22724 0.477362 6.51466 0.71829 6.74247 1.01098L9.43497 4.46998C9.92847 5.10448 10.1025 5.93098 9.90747 6.71098L9.08697 9.99598C9.04455 10.1661 9.04684 10.3443 9.09363 10.5133C9.14041 10.6823 9.23009 10.8364 9.35397 10.9605L13.0395 14.646C13.1637 14.7701 13.318 14.8599 13.4873 14.9067C13.6566 14.9535 13.8351 14.9557 14.0055 14.913L17.289 14.0925C17.6739 13.9962 18.0757 13.9888 18.4639 14.0706C18.8521 14.1525 19.2167 14.3215 19.53 14.565L22.989 17.256C24.2325 18.2235 24.3465 20.061 23.2335 21.1725L21.6825 22.7235C20.5725 23.8335 18.9135 24.321 17.367 23.7765C13.4087 22.3838 9.81488 20.1177 6.85197 17.1465C3.88091 14.184 1.61489 10.5907 0.221974 6.63298C-0.321026 5.08798 0.166474 3.42748 1.27647 2.31748L2.82747 0.766476Z"
                      fill="#622167"
                    />
                  </svg>
                  <p>(11) 4753-4705</p>
                </div>
                <div className={styles.info}>
                  <svg
                    width="24"
                    height="28"
                    viewBox="0 0 24 28"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <path
                      d="M12 14C12.825 14 13.5315 13.7256 14.1195 13.1768C14.7065 12.6289 15 11.97 15 11.2C15 10.43 14.7065 9.7706 14.1195 9.2218C13.5315 8.67393 12.825 8.4 12 8.4C11.175 8.4 10.469 8.67393 9.882 9.2218C9.294 9.7706 9 10.43 9 11.2C9 11.97 9.294 12.6289 9.882 13.1768C10.469 13.7256 11.175 14 12 14ZM12 28C7.975 24.8033 4.969 21.8339 2.982 19.0918C0.994 16.3506 0 13.8133 0 11.48C0 7.98 1.2065 5.19167 3.6195 3.115C6.0315 1.03833 8.825 0 12 0C15.175 0 17.9685 1.03833 20.3805 3.115C22.7935 5.19167 24 7.98 24 11.48C24 13.8133 23.0065 16.3506 21.0195 19.0918C19.0315 21.8339 16.025 24.8033 12 28Z"
                      fill="#622167"
                    />
                  </svg>
                  <p>Rua Carlos Barbosa da Silva, 51 - Centro - 08570-140</p>
                </div>
              </div>
              <div className={styles.socials}>
                <div className="">
                  <svg
                    width="64"
                    height="64"
                    viewBox="0 0 64 64"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <circle cx="32" cy="32" r="32" fill="#622167" />
                    <path
                      d="M34 33.8H37.5714L39 29H34V26.6C34 25.364 34 24.2 36.8571 24.2H39V20.168C38.5343 20.1164 36.7757 20 34.9186 20C31.04 20 28.2857 21.9884 28.2857 25.64V29H24V33.8H28.2857V44H34V33.8Z"
                      fill="#EEEEEE"
                    />
                  </svg>
                </div>
                <div className="">
                  <svg
                    width="64"
                    height="64"
                    viewBox="0 0 64 64"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <circle cx="32" cy="32" r="32" fill="#622167" />
                    <g clipPath="url(#clip0_64_69)">
                      <path
                        d="M32 20C28.7435 20 28.334 20.015 27.0545 20.072C25.775 20.132 24.9035 20.333 24.14 20.63C23.3391 20.9312 22.6137 21.4037 22.0145 22.0145C21.4041 22.614 20.9317 23.3394 20.63 24.14C20.333 24.902 20.1305 25.775 20.072 27.05C20.015 28.3325 20 28.7405 20 32.0015C20 35.2595 20.015 35.6675 20.072 36.947C20.132 38.225 20.333 39.0965 20.63 39.86C20.9375 40.649 21.347 41.318 22.0145 41.9855C22.6805 42.653 23.3495 43.064 24.1385 43.37C24.9035 43.667 25.7735 43.8695 27.0515 43.928C28.3325 43.985 28.7405 44 32 44C35.2595 44 35.666 43.985 36.947 43.928C38.2235 43.868 39.098 43.667 39.8615 43.37C40.6618 43.0686 41.3867 42.5961 41.9855 41.9855C42.653 41.318 43.0625 40.649 43.37 39.86C43.6655 39.0965 43.868 38.225 43.928 36.947C43.985 35.6675 44 35.2595 44 32C44 28.7405 43.985 28.3325 43.928 27.0515C43.868 25.775 43.6655 24.902 43.37 24.14C43.0684 23.3393 42.5959 22.614 41.9855 22.0145C41.3864 21.4035 40.661 20.931 39.86 20.63C39.095 20.333 38.222 20.1305 36.9455 20.072C35.6645 20.015 35.258 20 31.997 20H32.0015H32ZM30.9245 22.163H32.0015C35.2055 22.163 35.585 22.1735 36.8495 22.232C38.0195 22.2845 38.6555 22.481 39.0785 22.6445C39.638 22.862 40.0385 23.123 40.4585 23.543C40.8785 23.963 41.138 24.362 41.3555 24.923C41.5205 25.3445 41.7155 25.9805 41.768 27.1505C41.8265 28.415 41.8385 28.7945 41.8385 31.997C41.8385 35.1995 41.8265 35.5805 41.768 36.845C41.7155 38.015 41.519 38.6495 41.3555 39.0725C41.1631 39.5935 40.856 40.0647 40.457 40.451C40.037 40.871 39.638 41.1305 39.077 41.348C38.657 41.513 38.021 41.708 36.8495 41.762C35.585 41.819 35.2055 41.8325 32.0015 41.8325C28.7975 41.8325 28.4165 41.819 27.152 41.762C25.982 41.708 25.3475 41.513 24.9245 41.348C24.4032 41.1559 23.9317 40.8494 23.5445 40.451C23.1451 40.0641 22.8376 39.5925 22.6445 39.071C22.481 38.6495 22.2845 38.0135 22.232 36.8435C22.175 35.579 22.163 35.1995 22.163 31.994C22.163 28.79 22.175 28.412 22.232 27.1475C22.286 25.9775 22.481 25.3415 22.646 24.9185C22.8635 24.359 23.1245 23.9585 23.5445 23.5385C23.9645 23.1185 24.3635 22.859 24.9245 22.6415C25.3475 22.4765 25.982 22.2815 27.152 22.2275C28.259 22.1765 28.688 22.1615 30.9245 22.16V22.163ZM38.4065 24.155C38.2174 24.155 38.0301 24.1922 37.8554 24.2646C37.6807 24.337 37.522 24.443 37.3883 24.5768C37.2545 24.7105 37.1485 24.8692 37.0761 25.0439C37.0037 25.2186 36.9665 25.4059 36.9665 25.595C36.9665 25.7841 37.0037 25.9714 37.0761 26.1461C37.1485 26.3208 37.2545 26.4795 37.3883 26.6132C37.522 26.747 37.6807 26.853 37.8554 26.9254C38.0301 26.9978 38.2174 27.035 38.4065 27.035C38.7884 27.035 39.1547 26.8833 39.4247 26.6132C39.6948 26.3432 39.8465 25.9769 39.8465 25.595C39.8465 25.2131 39.6948 24.8468 39.4247 24.5768C39.1547 24.3067 38.7884 24.155 38.4065 24.155ZM32.0015 25.838C31.1841 25.8252 30.3723 25.9752 29.6135 26.2792C28.8546 26.5832 28.1638 27.0351 27.5812 27.6086C26.9987 28.1822 26.536 28.8659 26.2203 29.6199C25.9045 30.3739 25.7419 31.1833 25.7419 32.0007C25.7419 32.8182 25.9045 33.6276 26.2203 34.3816C26.536 35.1356 26.9987 35.8193 27.5812 36.3929C28.1638 36.9664 28.8546 37.4183 29.6135 37.7223C30.3723 38.0263 31.1841 38.1763 32.0015 38.1635C33.6193 38.1383 35.1623 37.4779 36.2975 36.3249C37.4326 35.1719 38.0689 33.6188 38.0689 32.0007C38.0689 30.3827 37.4326 28.8296 36.2975 27.6766C35.1623 26.5236 33.6193 25.8632 32.0015 25.838ZM32.0015 27.9995C33.0625 27.9995 34.08 28.421 34.8303 29.1712C35.5805 29.9215 36.002 30.939 36.002 32C36.002 33.061 35.5805 34.0785 34.8303 34.8288C34.08 35.579 33.0625 36.0005 32.0015 36.0005C30.9405 36.0005 29.923 35.579 29.1727 34.8288C28.4225 34.0785 28.001 33.061 28.001 32C28.001 30.939 28.4225 29.9215 29.1727 29.1712C29.923 28.421 30.9405 27.9995 32.0015 27.9995Z"
                        fill="#EEEEEE"
                      />
                    </g>
                    <defs>
                      <clipPath id="clip0_64_69">
                        <rect
                          width="24"
                          height="24"
                          fill="white"
                          transform="translate(20 20)"
                        />
                      </clipPath>
                    </defs>
                  </svg>
                </div>
              </div>
            </div>
            {!isSubmitted ? (
              <form action="" className={styles.form} onSubmit={handleSubmit}>
                {inputs.map((item) => (
                  <div key={item.name} className={styles.input_container}>
                    <input
                      type={item.type}
                      placeholder={item.label}
                      name={item.name}
                      required
                      onChange={handleChange}
                    />
                  </div>
                ))}
                <ButtonFragment type="submit">
                  <div style={{ display: "flex", alignItems: "center" }}>
                    <svg
                      style={{ marginRight: "8px", paddingBottom: "2px" }}
                      width="24"
                      height="24"
                      viewBox="0 0 24 24"
                      fill="none"
                      xmlns="http://www.w3.org/2000/svg"
                    >
                      <path
                        d="M23.9471 1.02871C24.0017 0.892413 24.015 0.743103 23.9855 0.599288C23.956 0.455474 23.885 0.32348 23.7812 0.21967C23.6774 0.11586 23.5454 0.0448002 23.4015 0.015299C23.2577 -0.0142021 23.1084 -0.000846891 22.9721 0.0537091L1.15162 8.78221H1.15012L0.472125 9.05221C0.34371 9.10343 0.231953 9.18915 0.149198 9.2999C0.0664433 9.41066 0.0159116 9.54213 0.00318483 9.67979C-0.00954198 9.81746 0.0160314 9.95597 0.0770801 10.08C0.138129 10.2041 0.232277 10.3088 0.349125 10.3827L0.964125 10.7727L0.965625 10.7757L8.45812 15.5427L13.2251 23.0352L13.2281 23.0382L13.6181 23.6532C13.6923 23.7696 13.7971 23.8633 13.921 23.924C14.045 23.9846 14.1833 24.0099 14.3207 23.997C14.4581 23.9842 14.5892 23.9336 14.6998 23.851C14.8103 23.7684 14.8959 23.6569 14.9471 23.5287L23.9471 1.02871ZM21.1976 3.86371L9.95662 15.1047L9.63412 14.5977C9.57503 14.5047 9.49616 14.4258 9.40312 14.3667L8.89612 14.0442L20.1371 2.80321L21.9041 2.09671L21.1991 3.86371H21.1976Z"
                        fill="#EEEEEE"
                      />
                    </svg>
                    Enviar mensagem
                  </div>
                </ButtonFragment>
              </form>
            ) : (
              <div
                style={{
                  width: "100%",
                  display: "flex",
                  justifyContent: "center",
                }}
              >
                Mensagem enviada
              </div>
            )}
          </div>
          <div className={styles.svg_illustration}>
            <svg
              width="327"
              height="297"
              viewBox="0 0 327 297"
              style={{ zIndex: "2" }}
              fill="none"
              xmlns="http://www.w3.org/2000/svg"
            >
              <path
                d="M248.823 0.0289239C266.323 -0.479186 283.733 5.70775 298.453 18.5749C316.85 34.655 326.788 54.6507 326.997 79.6975C327.385 123.574 291.13 160.053 247.866 159.994C202.54 159.934 167.361 124.934 166.733 80.1608C166.15 38.6602 201.554 -1.09191 248.808 0.0289239H248.823ZM200.777 79.7124C199.745 102.204 218.725 125.965 246.536 126.16C272.285 126.339 293.297 105.462 293.163 79.7572C293.043 54.5311 272.45 33.7883 247.134 33.6389C219.621 33.4745 199.865 57.0269 200.777 79.7274V79.7124Z"
                fill="#00BAB3"
                fillOpacity="0.15"
              />
              <path
                d="M70.4311 176.702C95.0295 175.925 113.815 186.983 126.562 199.731C142.269 215.467 150.115 234.522 150.264 257.207C150.548 301.951 112.828 337.249 69.7885 336.771C24.4621 336.263 -9.85022 299.485 -9.99967 256.52C-10.1342 213.51 26.3451 175.312 70.446 176.687L70.4311 176.702ZM70.461 302.817C96.0458 302.713 116.564 281.955 116.46 256.281C116.355 230.905 95.3284 210.237 69.7436 210.371C44.4428 210.506 24.0287 231.189 23.9988 256.609C23.9839 282.149 44.5175 303.101 70.461 302.817Z"
                fill="#00BAB3"
                fillOpacity="0.15"
              />
              <path
                d="M248.121 176.701C253.889 175.954 260.704 178.614 267.743 178.136C271.658 180.766 276.276 181.783 280.49 183.755C294.762 190.45 305.746 200.822 314.593 213.689C318.285 219.054 320.825 224.972 323.246 230.92C325.578 236.658 326.086 242.905 326.564 249.047C328.312 271.404 322.454 291.31 307.794 308.66C302.414 315.027 296.077 320.048 289.308 324.561C273.272 335.261 255.399 338.28 236.509 336.039C215.662 333.558 198.416 323.993 185.369 307.764C164.238 281.477 160.696 252.425 174.923 221.878C185.309 199.551 203.123 185.429 226.93 178.988C233.43 177.224 240.096 176.746 248.091 176.716L248.121 176.701ZM200.762 256.504C199.82 281.013 221.475 303.251 246.836 302.907C272.465 302.548 293.223 282.104 293.163 256.549C293.103 231.263 272.405 210.595 247.134 210.356C220.758 210.102 199.88 232.818 200.777 256.504H200.762Z"
                fill="#00BAB3"
                fillOpacity="0.15"
              />
            </svg>
          </div>
        </div>
      </div>
    </div>
  );
};

export default ContactForm;
