import React, { useState } from "react";
import styles from "./style.module.scss";
import Image from "next/image";
import standardlogo from "../../assets/standardlogo.png";
import itaqua from "../../assets/itaqua.png";
import { useRouter } from "next/router";
import CadastroModal from "../cadastro_modal";
import androidImg from "./../../assets/android.png"
import iOsImg from "./../../assets/iOs.png"
import bals from "./../../assets/bals.png"
import whatsapp from "./../../assets/whatsapp.png"
import instagram from "./../../assets/InstagramLogo.png"
import email from "./../../assets/email.png"

const Footer = () => {
  const router = useRouter();
  const [isCadastroModalOpen, setIsCadastroModalOpen] = useState(false);
  const navigateToPage = (slug: string) => router.push(slug);
  const scrollNavigate = ( element_id: string ) => {
    if (router.pathname !== '/') {
      router.push(`/#${element_id}`)
    } else {
      document.getElementById(element_id)?.scrollIntoView({behavior: 'smooth'})
    }
  }
  const navigateToExternalPage = (external_url: string) =>
    window.open(external_url, "_blank");

  const handleCadastroClick = () => {
    setIsCadastroModalOpen(true);
  };

  const handleCloseCadastroModal = () => {
    setIsCadastroModalOpen(false);
  };

  const instagramLink = "https://www.instagram.com/moov.itaqua"
  const whatsappLink:string = "https://wa.me/5511933152362"

  const services = [
    // { name: "Linhas", onClick: () => navigateToPage("linhas") },
    // { name: "Cadastre-se", onClick: handleCadastroClick },
    // { name: "Recarregue/Compre", onClick: () => navigateToExternalPage("http://191.242.203.30:8014/wbc-st5/login.faces") },
    { name: "Vale Transporte", onClick: () => navigateToExternalPage("") },
    { name: "Vale Comum", onClick: () => navigateToExternalPage("") },
    { name: "Vale Escolar", onClick: () => navigateToExternalPage("") },
  ];

  const apps = [
    {
      name:<img src={iOsImg.src} alt="iOS" />, onClick: () => navigateToExternalPage("https://apps.apple.com/br/app/moov-itaqu%C3%A1/id6483494881")
    },
    {
      name:<img src={androidImg.src} alt="Android" />, onClick: () => navigateToExternalPage("https://play.google.com/store/apps/details?id=br.bus2.moovitaqua&hl=pt_BR")
    }
  ];

  const pages = [
    //falta arrumar a rota aqui
    { name: "Linhas", onClick: () => navigateToPage("linhas") },
    { name: "Notícias", onClick: () => navigateToPage("news") },
    // { name: "Sobre nós", onClick: () => scrollNavigate("aboutus") },
    // { name: "Contato", onClick: () => scrollNavigate("contactus") },
    { name: "FAQ", onClick: () => navigateToPage("faq") },
  ];

  return (
    <footer className={styles.footer_container}>
      <div className={styles.footer_content}>
        <div className={styles.images}>
          <div className={styles.image_container}>
            <Image
              src={standardlogo}
              alt="Moov Itaguá Standard logo"
              style={{ objectFit: "contain" }}
            />
          </div>
          <div className={styles.image_container}>
            <Image
              src={itaqua}
              alt="Itaguá logo"
              style={{ objectFit: "contain" }}
            />
          </div>
        </div>
        <div className={styles.footer_navigation}>
          <div>
            <h2>Páginas</h2>
            <ul>
              {pages.map((item) => (
                <li key={item.name} onClick={() => item?.onClick()}>
                  <span className={styles.nav_text}>{item.name}</span>
                  <svg
                    width="24"
                    height="24"
                    viewBox="0 0 24 24"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <path
                      d="M7.14999 21.1C6.89999 20.85 6.77499 20.554 6.77499 20.212C6.77499 19.87 6.89999 19.5743 7.14999 19.325L14.475 12L7.12499 4.65C6.89166 4.41667 6.77499 4.125 6.77499 3.775C6.77499 3.425 6.89999 3.125 7.14999 2.875C7.39999 2.625 7.69599 2.5 8.03799 2.5C8.37999 2.5 8.67566 2.625 8.92499 2.875L17.325 11.3C17.425 11.4 17.496 11.5083 17.538 11.625C17.58 11.7417 17.6007 11.8667 17.6 12C17.6 12.1333 17.579 12.2583 17.537 12.375C17.495 12.4917 17.4243 12.6 17.325 12.7L8.89999 21.125C8.66666 21.3583 8.37899 21.475 8.03699 21.475C7.69499 21.475 7.39933 21.35 7.14999 21.1Z"
                      fill="#622167"
                    />
                  </svg>
                </li>
              ))}
            </ul>
          </div>
          <div>
            <h2>Recarregue</h2>
            <ul>
              {services.map((item) => (
                <li key={item?.name} onClick={() => item?.onClick()}>
                  <span className={styles.nav_text}>{item?.name}</span>
                  <svg
                    width="24"
                    height="24"
                    viewBox="0 0 24 24"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <path
                      d="M7.14999 21.1C6.89999 20.85 6.77499 20.554 6.77499 20.212C6.77499 19.87 6.89999 19.5743 7.14999 19.325L14.475 12L7.12499 4.65C6.89166 4.41667 6.77499 4.125 6.77499 3.775C6.77499 3.425 6.89999 3.125 7.14999 2.875C7.39999 2.625 7.69599 2.5 8.03799 2.5C8.37999 2.5 8.67566 2.625 8.92499 2.875L17.325 11.3C17.425 11.4 17.496 11.5083 17.538 11.625C17.58 11.7417 17.6007 11.8667 17.6 12C17.6 12.1333 17.579 12.2583 17.537 12.375C17.495 12.4917 17.4243 12.6 17.325 12.7L8.89999 21.125C8.66666 21.3583 8.37899 21.475 8.03699 21.475C7.69499 21.475 7.39933 21.35 7.14999 21.1Z"
                      fill="#622167"
                    />
                  </svg>
                </li>
              ))}
            </ul>
          </div>
          <div>
            <h2>App Moov Itaquá</h2>
            <ul>
              {
                apps.map((item, index) => (
                  <li key={index} onClick={() => item?.onClick()}>
                    <span className={styles.nav_text}>{item?.name}</span>
                  </li>
                ))
              }
            </ul>
          </div>
          <div className={styles.redeSocialContent}>
            <div className={styles.redeSocial}>
              <Image src={instagram} alt="Instagram"/>
              <a href={instagramLink} target="_blank">
                <p>@moov.itaqua</p>
              </a>
            </div>
            <div className={styles.redeSocial}>
              <Image src={whatsapp} alt="Whatsapp"/>
              <a href={whatsappLink} target="_blank">
                <p>(11) 93315-2362</p>
              </a>
            </div>
            <div className={styles.redeSocial}>
              <Image src={email} alt="Email"/>
              <p>atendimento@moovitaqua.com.br</p>
            </div>
            <div className={styles.address}>
              <p>Rua Carlos Barbosa da Silva, 51 - centro</p>
              <p>Itaquaquecetuba - SP, 08570-140</p>
              <p>Atendimento: Segunda a Sexta das 8 às 17h.</p>
            </div>
          </div>
        </div>
      </div>
      <div className={styles.privacy}>
        <a href="/documentos/termos-de-uso-e-politica-de-privacidade.pdf" target="_blank">Política de Privacidade</a>
      </div>
      <div className={styles.svg_image}>
        {/* <svg
          width="327"
          height="297"
          viewBox="0 0 327 297"
          fill="none"
          xmlns="http://www.w3.org/2000/svg"
        >
          <path
            d="M248.823 0.0289239C266.323 -0.479186 283.733 5.70775 298.453 18.5749C316.85 34.655 326.788 54.6507 326.997 79.6975C327.385 123.574 291.13 160.053 247.866 159.994C202.54 159.934 167.361 124.934 166.733 80.1608C166.15 38.6602 201.554 -1.09191 248.808 0.0289239H248.823ZM200.777 79.7124C199.745 102.204 218.725 125.965 246.536 126.16C272.285 126.339 293.297 105.462 293.163 79.7572C293.043 54.5311 272.45 33.7883 247.134 33.6389C219.621 33.4745 199.865 57.0269 200.777 79.7274V79.7124Z"
            fill="#00BAB3"
            fillOpacity="0.15"
          />
          <path
            d="M70.4311 176.702C95.0295 175.925 113.815 186.983 126.562 199.731C142.269 215.467 150.115 234.522 150.264 257.207C150.548 301.951 112.828 337.249 69.7885 336.771C24.4621 336.263 -9.85022 299.485 -9.99967 256.52C-10.1342 213.51 26.3451 175.312 70.446 176.687L70.4311 176.702ZM70.461 302.817C96.0458 302.713 116.564 281.955 116.46 256.281C116.355 230.905 95.3284 210.237 69.7436 210.371C44.4428 210.506 24.0287 231.189 23.9988 256.609C23.9839 282.149 44.5175 303.101 70.461 302.817Z"
            fill="#00BAB3"
            fillOpacity="0.15"
          />
          <path
            d="M248.121 176.701C253.889 175.954 260.704 178.614 267.743 178.136C271.658 180.766 276.276 181.783 280.49 183.755C294.762 190.45 305.746 200.822 314.593 213.689C318.285 219.054 320.825 224.972 323.246 230.92C325.578 236.658 326.086 242.905 326.564 249.047C328.312 271.404 322.454 291.31 307.794 308.66C302.414 315.027 296.077 320.048 289.308 324.561C273.272 335.261 255.399 338.28 236.509 336.039C215.662 333.558 198.416 323.993 185.369 307.764C164.238 281.477 160.696 252.425 174.923 221.878C185.309 199.551 203.123 185.429 226.93 178.988C233.43 177.224 240.096 176.746 248.091 176.716L248.121 176.701ZM200.762 256.504C199.82 281.013 221.475 303.251 246.836 302.907C272.465 302.548 293.223 282.104 293.163 256.549C293.103 231.263 272.405 210.595 247.134 210.356C220.758 210.102 199.88 232.818 200.777 256.504H200.762Z"
            fill="#00BAB3"
            fillOpacity="0.15"
          />
        </svg> */}

        <Image src={bals} alt="Moov" />
      </div>
      
      {/* <CadastroModal 
        isOpen={isCadastroModalOpen} 
        handleCloseModal={handleCloseCadastroModal} 
      /> */}
    </footer>
  );
};

export default Footer;
