import Image from 'next/image'
import MobileNavigation from './mobile_navigation'
import styles from './style.module.scss'
import logo from '../../assets/logo.png'
import whatsapp from '../../assets/whatsapp.png'
import { useRouter } from 'next/router'
import Link from 'next/link'
import { useState, ReactNode } from 'react'
import CadastroModal from '../cadastro_modal'

interface NavigationItem {
  name: string
  onClick?: () => void
  url?: string
  target?: string
  icon?: ReactNode
}

const Header = () => {
  const router = useRouter()
  const [isCadastroModalOpen, setIsCadastroModalOpen] = useState(false)
  const navigateToPage = ( slug: string ) => router.push(slug)

  const scrollNavigate = ( element_id: string ) => {
    if (router.pathname !== '/') {
      router.push(`/#${element_id}`)
    } else {
      document.getElementById(element_id)?.scrollIntoView({behavior: 'smooth'})
    }
  }
  const navigateToOutsidePage = ( external_url: string ) => window.open(external_url, '_blank')

  const handleCadastroClick = () => {
    setIsCadastroModalOpen(true)
  }

  const handleCloseCadastroModal = () => {
    setIsCadastroModalOpen(false)
  }

  const chatbotLink:string = "https://linktr.ee/Moov.Itaqua?utm_source=linktree_profile_share&ltsid=e0c848cb-fa9b-42cd-afd6-7eb39af73d3a";

  const navigation_items: NavigationItem[] = [
    {
      name: 'Linhas',
      onClick: () => navigateToPage("linhas"),
      url: '/linhas',
      icon: <svg width="16" height="19" viewBox="0 0 16 19" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M2 19C1.71667 19 1.479 18.904 1.287 18.712C1.095 18.52 0.999333 18.2827 1 18V15.95C0.7 15.6167 0.458333 15.2457 0.275 14.837C0.0916668 14.4283 0 13.9827 0 13.5V4C0 2.61667 0.641667 1.604 1.925 0.962001C3.20833 0.320001 5.23333 -0.000665629 8 1.03734e-06C10.8667 1.03734e-06 12.9167 0.308334 14.15 0.925001C15.3833 1.54167 16 2.56667 16 4V13.5C16 13.9833 15.9083 14.4293 15.725 14.838C15.5417 15.2467 15.3 15.6173 15 15.95V18C15 18.2833 14.904 18.521 14.712 18.713C14.52 18.905 14.2827 19.0007 14 19H13C12.7167 19 12.479 18.904 12.287 18.712C12.095 18.52 11.9993 18.2827 12 18V17H4V18C4 18.2833 3.904 18.521 3.712 18.713C3.52 18.905 3.28267 19.0007 3 19H2ZM8.05 3H13.65H2.45H8.05ZM12 10H2H14H12ZM2 8H14V5H2V8ZM4.5 14C4.91667 14 5.271 13.854 5.563 13.562C5.855 13.27 6.00067 12.916 6 12.5C6 12.0833 5.854 11.729 5.562 11.437C5.27 11.145 4.916 10.9993 4.5 11C4.08333 11 3.729 11.146 3.437 11.438C3.145 11.73 2.99933 12.084 3 12.5C3 12.9167 3.146 13.271 3.438 13.563C3.73 13.855 4.084 14.0007 4.5 14ZM11.5 14C11.9167 14 12.271 13.854 12.563 13.562C12.855 13.27 13.0007 12.916 13 12.5C13 12.0833 12.854 11.729 12.562 11.437C12.27 11.145 11.916 10.9993 11.5 11C11.0833 11 10.729 11.146 10.437 11.438C10.145 11.73 9.99933 12.084 10 12.5C10 12.9167 10.146 13.271 10.438 13.563C10.73 13.855 11.084 14.0007 11.5 14ZM2.45 3H13.65C13.4 2.71667 12.8623 2.479 12.037 2.287C11.2117 2.095 9.88267 1.99933 8.05 2C6.26667 2 4.96233 2.10433 4.137 2.313C3.31167 2.52167 2.74933 2.75067 2.45 3ZM4 15H12C12.55 15 13.021 14.804 13.413 14.412C13.805 14.02 14.0007 13.5493 14 13V10H2V13C2 13.55 2.196 14.021 2.588 14.413C2.98 14.805 3.45067 15.0007 4 15Z" fill="#622167"/>
      </svg>
    },
    {
      name: 'Recarregar Vale Comum',
      onClick: () => navigateToOutsidePage(chatbotLink),
      url: chatbotLink,
      target: '_blank',
      icon: <svg width="22" height="18" viewBox="0 0 22 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M20 0C20.53 0 21.04 0.21 21.41 0.59C21.79 0.96 22 1.47 22 2V12C22 12.53 21.79 13.04 21.41 13.41C21.04 13.79 20.53 14 20 14H6C5.47 14 4.96 13.79 4.59 13.41C4.21 13.04 4 12.53 4 12V2C4 1.47 4.21 0.96 4.59 0.59C4.96 0.21 5.47 0 6 0H20ZM2 16H17V18H2C1.47 18 0.96 17.79 0.59 17.41C0.21 17.04 0 16.53 0 16V5H2V16Z" fill="#622167"/>
      </svg>
    },
    {
      name: 'Recarregar Vale Escolar',
      onClick: () => navigateToOutsidePage(chatbotLink),
      url: chatbotLink,
      target: '_blank',
      icon: <svg width="22" height="18" viewBox="0 0 22 18" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M20 0C20.53 0 21.04 0.21 21.41 0.59C21.79 0.96 22 1.47 22 2V12C22 12.53 21.79 13.04 21.41 13.41C21.04 13.79 20.53 14 20 14H6C5.47 14 4.96 13.79 4.59 13.41C4.21 13.04 4 12.53 4 12V2C4 1.47 4.21 0.96 4.59 0.59C4.96 0.21 5.47 0 6 0H20ZM2 16H17V18H2C1.47 18 0.96 17.79 0.59 17.41C0.21 17.04 0 16.53 0 16V5H2V16Z" fill="#622167"/>
      </svg>
    },
    {
      name: 'Notícias',
      onClick: () => navigateToPage("news"),
      url: '/news',
      icon: <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" className="lucide lucide-newspaper-icon lucide-newspaper">
      <path d="M15 18h-5"/><path d="M18 14h-8"/><path d="M4 22h16a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2H8a2 2 0 0 0-2 2v16a2 2 0 0 1-4 0v-9a2 2 0 0 1 2-2h2"/><rect width="8" height="4" x="10" y="6" rx="1"/></svg>
    },
    {
      name: 'FAQ',
      onClick: () => navigateToPage("faq"),
      url: '/faq',
      icon: <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M2 0H18C18.5304 0 19.0391 0.210714 19.4142 0.585786C19.7893 0.960859 20 1.46957 20 2V14C20 14.5304 19.7893 15.0391 19.4142 15.4142C19.0391 15.7893 18.5304 16 18 16H11.9L8.2 19.71C8 19.9 7.75 20 7.5 20H7C6.73478 20 6.48043 19.8946 6.29289 19.7071C6.10536 19.5196 6 19.2652 6 19V16H2C1.46957 16 0.960859 15.7893 0.585786 15.4142C0.210714 15.0391 0 14.5304 0 14V2C0 1.46957 0.210714 0.960859 0.585786 0.585786C0.960859 0.210714 1.46957 0 2 0ZM10.19 3.5C9.3 3.5 8.59 3.68 8.05 4.04C7.5 4.4 7.22 5 7.27 5.69H9.24C9.24 5.41 9.34 5.2 9.5 5.06C9.7 4.92 9.92 4.85 10.19 4.85C10.5 4.85 10.77 4.93 10.95 5.11C11.13 5.28 11.22 5.5 11.22 5.8C11.22 6.08 11.14 6.33 11 6.54C10.83 6.76 10.62 6.94 10.36 7.08C9.84 7.4 9.5 7.68 9.29 7.92C9.1 8.16 9 8.5 9 9H11C11 8.72 11.05 8.5 11.14 8.32C11.23 8.15 11.4 8 11.66 7.85C12.12 7.64 12.5 7.36 12.79 7C13.08 6.63 13.23 6.24 13.23 5.8C13.23 5.1 12.96 4.54 12.42 4.12C11.88 3.71 11.13 3.5 10.19 3.5ZM9 10V12H11V10H9Z" fill="#622167"/>
      </svg>
    }
  ]
  return (
    <header className={styles.header_container}>
      <div className={styles.logo_container} onClick={() => navigateToPage('/')} style={{cursor: 'pointer'}}>
        <Image src={logo}  alt='Moov Itaguá logo' className={styles.logo_image} />
      </div>
      <nav>
        <ul className={styles.desktop_nav}>
          {navigation_items.map(item => (
            <li key={item.name}>
              {item.onClick ? (
                <button
                  onClick={item.onClick}
                  className={styles.nav_button}
                >
                  {item.name}
                </button>
              ) : item.url ? (
                <Link
                  href={item.url}
                  target={item.target ? item.target : '_self'}
                >
                  {item.name}
                </Link>
              ) : (
                <span className={styles.nav_button}>{item.name}</span>
              )}
            </li>
          ))}
        </ul>
      </nav>
        <div className={styles.chatbot}>
          <a onClick={ ()=> navigateToOutsidePage("https://linktr.ee/Moov.Itaqua?utm_source=linktree_profile_share&ltsid=e0c848cb-fa9b-42cd-afd6-7eb39af73d3a")}>
            <Image src={whatsapp} alt="Whatsapp" />
            Chatbot
          </a>
        </div>
      <div className={styles.mobile_nav}>
        <MobileNavigation navigation_items={navigation_items} />
      </div>
      <CadastroModal
        isOpen={isCadastroModalOpen}
        handleCloseModal={handleCloseCadastroModal}
      />
    </header>
  )
}

export default Header
