import { useEffect } from 'react';
import styles from './styles.module.scss'
const PdfLineModal = ({item, handleCloseModal}: any) => {

    useEffect(() => {
        const handleOutsideClick = (event: any) => {
          if (event.target.id === 'overlay') {
            handleCloseModal();
          }
        };
    
        window.addEventListener('click', handleOutsideClick);
    
        return () => {
          window.removeEventListener('click', handleOutsideClick);
        };
    }, [handleCloseModal])
  return (
    <div className={styles.modal_overlay} id="overlay">
      <div className={styles.modal}>
        <div className={styles.modal_header}>
          <button className={styles.modal_close} onClick={handleCloseModal}>
            &times;
          </button>
        </div>
        <div className={styles.modal_content}>
          <iframe
            src={item}
            width="100%"
            height="600px"
          ></iframe>
        </div>
      </div>
    </div>
  );
}

export default PdfLineModal
