'use client';
import styles from './style.module.scss'

type ButtonFragmentProps = {
  children: any, 
  onClick?: (cb: any) => void,
  bgcolor?: string; 
  type?: string;
  href?: string;
};

const ButtonFragment = ({
  onClick, 
  bgcolor,
  children, 
  type,
  href = ''
}: ButtonFragmentProps) => {

  const isExternalLink = href[0] !== '/' ? true : false;
  const isEmptyLink = href === '' ? true : false;
  
  // Botão de link externo
  if (!isEmptyLink && isExternalLink) 
    return <a href={href} target="_blank" className={styles.btn}>{children}</a>  

  // Botão de ação
  return (
    <button className={styles.btn} onClick={onClick}>{children}</button> 
  );
}

export default ButtonFragment