import { useRouter } from 'next/router';
import React from 'react'
import styles from './style.module.scss'
import Image from 'next/image';


const NewsCard = ({item, category}: any) => {
    const router = useRouter();
    const img_src = process.env.NEXT_PUBLIC_ENDPOINT + item?.imagem?.data?.attributes?.url

  return (
    <div className={styles.card_container} onClick={() => router.push(`/news/${item?.slug}`)}>
        <div className={styles.card_image}>
          <Image src={img_src} crossOrigin="anonymous" alt={item?.titulo} width={447} height={452} />
        </div>
        <div className={styles.card_content}>
          <div className={styles.card_text}>
            <div className={styles.news_category}>
              {item?.categorias?.data[0]?.attributes?.nome?.toUpperCase() || category?.toUpperCase() || null}
            </div>
            <div className={styles.text_content}>
              <h2>{item?.titulo}</h2>
              <p>{item?.descricao}</p>
            </div>
          </div>
          <div className={styles.read_more_container}>
              <button onClick={() => router.push(`/news/${item?.slug}`) }>Ler mais</button>
          </div>

        </div>
    </div>
  )
}

export default NewsCard