import BasicLayout from "@/layout/basic_layout";
import { NextPage } from "next";
import type { AppProps } from "next/app";
import { ReactNode, useEffect } from "react";
import { Roboto } from "next/font/google";
import { useRouter } from "next/router";

import "@/styles/variables.scss";
import "@/styles/globals.scss";
import "@/styles/breakpoints.scss";

type ExtendedAppProps = AppProps & {
  Component: NextPage & {
    getLayout: (page: ReactNode) => ReactNode;
  };
};
const roboto = Roboto({
  weight: ["100", "300", "400", "500", "700"],
  style: ["normal"],
  subsets: ["latin"],
  display: "swap",
});
export default function App({ Component, pageProps }: ExtendedAppProps) {
	 const {pathname} = useRouter()
  useEffect(() => {
    if (pathname === '/faq' || pathname === '/news' || pathname === '/linhas') {
      const header_element = document.querySelector('header')
      header_element?.scrollIntoView();
    }
  }, [pathname]);
  const getLayout =
    Component.getLayout ??
    ((page) => (
      <>
        <BasicLayout>{page}</BasicLayout>
      </>
    ));

  return getLayout(
    <main className={roboto.className}>
      <Component {...pageProps} />{" "}
    </main>
  );
}
