const nodemailer = require("nodemailer");
import type { NextApiRequest, NextApiResponse } from 'next'

export default function handler(
  req: NextApiRequest,
  res: NextApiResponse<any>
) {
    const {name, email, message} = req.body
    console.log(req.body)
    
    const transporter = nodemailer.createTransport({
        host: "mail.moovitaqua.com.br",
        port: 26,
        secure: false, // true for 465, false for other ports
        auth: {
            user: process.env.NEXT_PUBLIC_EMAIL_USER, // generated ethereal user
            pass: process.env.NEXT_PUBLIC_EMAIL_PASSWORD, // generated ethereal password
        },
        tls: {
            rejectUnauthorized: false
        },
    });

    console.log(transporter)

    const mailData = {
        from: `${name} <${process.env.NEXT_PUBLIC_EMAIL_USER}>`, // sender address
        to: `${process.env.NEXT_PUBLIC_EMAIL_USER}`, // list of receivers
        replyTo: `${email}`,
        subject: `Moov Itaqua Formulário Site`, // Subject line
        text: `${message}`, // plain text body
        html: `<h3>${message}</h3>`
    }
    transporter.sendMail(mailData, function (err: any, info: any) {
        if (err) {
            console.log('err', err)
            res.status(400).json({ message: 'Error'})
        }
        else {
            res.status(200).json({ message: 'Success'})
        }
    })
    
}
