import Image from 'next/image'
import React, { useEffect, useState } from 'react'

import woman from '../../assets/womansmile.png'
import styles from './style.module.scss'
import FaqItem from '@/fragments/faq_item'
import api from '@/services/api'

const FAQPage = () => {
  // const [faqItems, setFaqItems] = useState<any[]>([]);
  // const [faqItemsFirstHalf, setFaqItemsFirstHalf] = useState<any[]>([]);
  // const [faqItemsSecondHalf, setFaqItemsSecondHalf] = useState<any[]>([]);
//
  // const [loading, setLoading] = useState(false);

  // useEffect(() => {
  //   getFaqItems();
  // }, []);

  // async function getFaqItems() {
  //   try {
  //     setLoading(true);

  //     const res = await api.get('/faqs?sort=ordem:ASC')
  //     const {data, status } = res

  //     if (status !== 200) throw new Error()

  //     setFaqItems(data.data);

  //     setLoading(true);

  //     console.log('faqItems:', faqItems);
  //     console.log('data.data:', data.data);

  //     const firstHalf = [] as any[];
  //     const secondHalf = [] as any[];

  //     data.data.forEach((item: any, index: number) => {
  //       if (index % 2 === 0) {
  //         firstHalf.push(item);
  //       } else {
  //         secondHalf.push(item);
  //       }
  //     });

  //     setFaqItemsFirstHalf(firstHalf);
  //     setFaqItemsSecondHalf(secondHalf);

  //     console.log('firstHalf', faqItemsFirstHalf);
  //     console.log('secondHalf', faqItemsSecondHalf);
  //   } catch (error) {
  //     console.log(error)
  //   }
  // }

  return (
    <main className={styles.faq_main}>
      <section className={styles.faq_inital_section}>
        <div className={styles.faq_text}>
          <h1>Tire suas dúvidas em nossa página de FAQ</h1>
        </div>
        <div className={styles.img_container}>
          <Image
            src={woman}
            style={{ objectFit: "contain", width: "100%" }}
            alt="Mulher sorrindo com celular na mão"
          />
        </div>
      </section>
      <div className={styles.faq_list_section}>
        <div className={styles.faq_list_container}>
            {/*<div className={styles.faq_list}>
              {faqItemsFirstHalf.map((item, key) => (
                <FaqItem
                  key={key}
                  item={{
                    question: item.attributes.pergunta,
                    answer: item.attributes.resposta
                  }}
                />
              ))}
            </div>

            <div className={styles.faq_list}>
              {faqItemsSecondHalf.map((item, key) => (
                <FaqItem
                  key={key}
                  item={{
                    question: item.attributes.pergunta,
                    answer: item.attributes.resposta
                  }}
                />
              ))}
            </div>*/}

            <div className={styles.faq_list}>
              <FaqItem
                item={{
                  question: 'Como efetuar recarga no cartão?',
                  answer: 'As recargas de cartões avulsos ou escolares podem ser feitas através do número (11) 95664-2530.'
                }}
              />

              <FaqItem
                item={{
                  question: 'Como solicitar o Vale-Transporte (VT)?',
                  answer: 'A empresa deve enviar um e-mail para empresas@moovitaqua.com.br com o assunto "Cadastro de Empresa". Após o envio, as instruções completas são encaminhadas automaticamente por resposta.'
                }}
              />

              <FaqItem
                item={{
                  question: 'Como consultar o saldo do cartão?',
                  answer: 'A consulta de saldo pode ser feita em nossa loja física ou diretamente na catraca do ônibus.'
                }}
              />

              <FaqItem
                item={{
                  question: 'Como realizar o cadastro ou recadastro escolar?'
                }}
              >
                <p>Siga as instruções no site: <a href="https://moovitaqua.com.br/escolar" target="_blank" rel="noopener noreferrer">https://moovitaqua.com.br/escolar</a></p>
                <ol>
                  <li>Baixe o formulário, imprima frente e verso e preencha conforme as instruções.</li>
                  <li>Peça para a direção da escola assinar e carimbar.</li>
                  <li>Envie o formulário para <a href="mailto:escolar@moovitaqua.com.br">escolar@moovitaqua.com.br</a> com os seguintes anexos:</li>
                </ol>
                <ul style={{ paddingLeft: '40px' }}>
                  <li>RG;</li>
                  <li>Comprovante de endereço recente (até 3 meses);</li>
                  <li>Foto com fundo branco.</li>
                </ul>
                <ol start={4}>
                  <li>Aguarde até 3 dias úteis para aprovação.</li>
                </ol>
              </FaqItem>

              <FaqItem
                item={{
                  question: 'Como solicitar o cartão comum Viaje Fácil?'
                }}
              >
                <p>Compareça à nossa loja com RG e valor para emissão e recarga:</p>

                <ul style={{ paddingLeft: '40px' }}>
                  <li>1ª via: R$ 6,80</li>
                  <li>Recarga mínima: R$ 5,80</li>
                </ul>
                <p>📍 Endereço: Rua Carlos Barbosa da Silva, 51 – Centro, Itaquaquecetuba (dentro da Associação Comercial, próximo ao Banco do Brasil)</p>
                <p>🕓 Atendimento: Segunda a sexta-feira, das 8h às 17h</p>
              </FaqItem>

              <FaqItem
                item={{
                  question: 'Como solicitar o cartão especial?'
                }}
              >
                <p>Apresente laudo médico original e atualizado na Isenção Tarifária, localizada em:</p>

                <p>📍 Rua Dom Tomás Frei, 89 – Centro, Itaquaquecetuba (piso superior do INSS, andar -3)</p>
                <p>🕓 Atendimento: Segunda a sexta, das 8h às 13h</p>
              </FaqItem>

              <FaqItem
                item={{
                  question: 'Como emitir o cartão do idoso?'
                }}
              >
                <p>Podem solicitar:</p>

                <ul style={{ paddingLeft: '40px' }}>
                  <li>Homens a partir de 65 anos</li>
                  <li>Mulheres a partir de 60 anos</li>
                  <li>É necessário residir em Itaquaquecetuba e apresentar RG e comprovante de endereço recente (até 90 dias).</li>
                  <li>Taxa da 1ª via: R$ 6,80</li>
                </ul>

                <p>📍 Endereço: Rua Manoel Garcia, 160 – Centro, Itaquaquecetuba</p>
                <p>🕓 Atendimento: Segunda a sexta, das 8h às 17h</p>
              </FaqItem>

              <FaqItem
                item={{
                  question: 'Como renovar o cartão do idoso?'
                }}
              >
                <p>Podem solicitar:</p>

                <ul style={{ paddingLeft: '40px' }}>
                  <li>Leve RG e comprovante de endereço atualizado (até 90 dias).</li>
                  <li>Taxa de renovação: R$ 6,80</li>
                </ul>

                <p>📍 Endereço: Rua Manoel Garcia, 160 – Centro, Itaquaquecetuba</p>
                <p>🕓 Atendimento: Segunda a sexta, das 8h às 17h</p>
              </FaqItem>



            </div>

            {/* NOVOS ITENS DE FAQ - INTEGRAÇÃO JAN/2025 */}
            <div className={styles.faq_list}>
              <FaqItem
                item={{
                  question: 'O cartão Viaje Fácil faz integração?'
                }}
              >
                <p>Podem solicitar:</p>

                <p>Sim. O cartão Viaje Fácil permite integração automática entre as linhas municipais.</p>
                <p>O passageiro pode integrar até duas linhas diferentes no período de 2 horas, reconhecida diretamente na catraca.</p>
              </FaqItem>

              <FaqItem
                item={{
                  question: 'Perdi meu cartão, como faço o bloqueio?'
                }}
              >
                <p>Podem solicitar:</p>

                <p>Entre em contato com a Moov pelo WhatsApp (11) 93315-2362 para solicitar o bloqueio imediato do seu cartão.</p>
              </FaqItem>

              <FaqItem
                item={{
                  question: 'Como entrar em contato com a Moov?'
                }}
              >
                <p>📱 WhatsApp oficial: (11) 93315-2362</p>
              </FaqItem>

              <FaqItem
                item={{
                  question: 'Como acompanhar as notícias e novidades da Moov?'
                }}
              >
                <p>Siga o perfil oficial no Instagram: @moov.itaqua</p>
              </FaqItem>

              <FaqItem
                item={{
                  question: 'Qual o prazo para aprovação do cadastro escolar?'
                }}
              >
                <p>O prazo para análise e aprovação é de até 3 dias úteis após o envio completo da documentação.</p>
              </FaqItem>

              <FaqItem
                item={{
                  question: 'Onde posso fazer recarga presencial do cartão?'
                }}
              >
                <p>As recargas presenciais podem ser feitas em nossa loja:</p>

                <p>📍 Rua Carlos Barbosa da Silva, 51 – Centro, Itaquaquecetuba</p>
                <p>🕓 Segunda a sexta, das 8h às 17h</p>
              </FaqItem>

              <FaqItem
                item={{
                  question: 'O que fazer em caso de cartão danificado?'
                }}
              >
                <p>Caso o cartão apresente defeito ou dano, compareça à loja Moov para substituição.</p>
                <p>Será cobrada a taxa de emissão de R$ 6,80, e o saldo será transferido para o novo cartão.</p>
              </FaqItem>
            </div>
            {/* FIM DOS NOVOS ITENS */}
        </div>
      </div>
    </main>
  );
}

export default FAQPage
