// Pode deletar a página, isso é para não prejudicar o SEO quando tentarem acessar essa página e redirecionar para home porque ela não existe mais


import Pagination from '@/fragments/pagination'
import styles from './style.module.scss'
import NewsCard from '@/fragments/news_card'
import api from '@/services/api'
import { useCallback, useEffect, useRef, useState } from 'react'
import Image from 'next/image'

// import selectIcon from '@/assets/icons/select-icon.png';
import selectIcon from '@/assets/icons/chevron-down.svg';

const NewsPage = () => {
  const [news, setNews] = useState<any[] | undefined>()
  const [categories, setCategories] = useState<any[] | undefined>()

  const [category, setCategory] = useState<string | undefined>()
  
  const [pagination, setPagination] = useState<any>({page: '', total_count: ''})

  const page_count = 9

  const category_ref: any = useRef()

  const getNews = useCallback(async (page?: number) => {
    try {
      const res = await api.get( `/noticias?populate=*&pagination[page]=${page}&pagination[pageSize]=${page_count}&sort=createdAt:desc`)
      console.log(res)
      const {data, status } = res
      if (status !== 200) throw new Error()
      setNews(data.data)
      setPagination(data.meta.pagination)
    } catch (error) {
      console.log(error)
      //setNews([])
    }
  }, [])

  const getNewsByCategory = async (page?: number, category_name?: string) => {
    try {
      const url = `/noticias?filters[categorias][nome][$contains]=${category_name}&populate=*&pagination[page]=${page}&pagination[pageSize]=${page_count}&sort=createdAt:desc` 
      const res = await api.get(url)
      const {data, status } = res
      if (status !== 200) throw new Error()
      setNews(data.data)
      setPagination(data.meta.pagination)
    } catch (error) {
      console.log(error)
    }
  }

  const getCategories = async () => {
    try {
      const res = await api.get(`/categorias`)
      const {data, status } = res
      if (status !== 200) throw new Error()
      setCategories(data.data)
    } catch (error) {
      console.log(error)
    }
  }

  useEffect(() => {
     if (!news) {
      getNews(1)
    }
    if (!categories) {
      getCategories()
    }
  }, [news, categories, getNews])

  function handleChangeCategory (e: any) {
    category_ref.current = {nome: e.target.childNodes[e.target.selectedIndex].id, id: e.target.value}
    setCategory(e.target.childNodes[e.target.selectedIndex].id)
    getNewsByCategory(1,  e.target.childNodes[e.target.selectedIndex].id)
  }

  function handleChangePage (page: number) {
    if (category) {
      getNewsByCategory(page, category)
    }
    if (!category) {
      getNews(page)
    }
  }


  return (
    <main className={styles.news_main_container}>
      <div className={styles.news_initial_info}>
        <h1>Notícias</h1>
        <div className={styles.category_select_container}>
          <Image src={selectIcon} alt="Icone Select" className={styles.category_select_icon} />
          <select className={styles.category_select} onChange={handleChangeCategory}>
            <option value="">Categorias</option>
            {categories?.map(item => (
              <option key={item.id} id={item.attributes.nome} value={item.id}>{item.attributes.nome}</option>
            ))}
          </select>
        </div>
      </div>

      <div className={styles.news_list_container}>
        {news?.map(item => (
              <NewsCard key={item.id} item={{...item.attributes, id: item.id}} category={category_ref?.current?.name} />
        ))}
      </div>
      <div style={{display: 'flex', justifyContent: 'center', alignItems: 'center', gap: '22px', width: '100%', gridColumn: '1/13'}}>
        <Pagination pagination={pagination} handleChangePage={handleChangePage} />
      </div>
    </main>
  )
}

export default NewsPage

// import { GetServerSideProps } from 'next'

// export const getServerSideProps: GetServerSideProps = async () => ({
//   redirect: {
//     destination: '/',
//     permanent: false,
//   },
// })

// export default function NewsRedirect() {
//   return null
// }
